
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Evans Fisher Gourio Krane %
% BPEA Spring 2015          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% this file calculates optimal policy (under discretion)
% in a forward-looking model, with predictable variation + persistent shock to natural rate,
% and persistent cost push shock. also calculates equilibrium under
% different rules for policy and compares the outcomes

clear all ; close all ; clc ;

%%%%%%%%%%%%%%%%%%
% set parameters %
%%%%%%%%%%%%%%%%%%

for usus=1:7
    
    basicparam ;
    
    % try different parameters
    if usus==1 ;
    end
    if usus==2
        std_epsX = .02/4 ;
    end
    if usus==3
        std_epsX = .03/4 ;
    end
    if usus==4
        rho0 = -0.01/4 ;
    end
    if usus==5
        rho0 = 0 ;
    end
    if usus==6
        ac_eps = .78 ;
    end
    if usus==7
        ac_eps = .92 ;
    end
    
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % the proper code starts here %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    input_shocks ;
    medeps = round(median((1:n_eps))) ;
    medu = round(median((1:n_u))) ;
    
    for is=1:3;
        
        % calculate 3 cases, corresponding to different values for the std dev
        % of the shock
        
        if is==1
            scaleX = 1e-7 ; % no uncertainty
        end
        if is==2
            scaleX = .5 ; % 50% as much uncertainty
        end
        if is==3
            scaleX = 1 ; % full uncertainty
        end
        
        % change the S.D
        std_u = std_uX*scaleX ;
        std_eps = std_epsX*scaleX ;
        
        % create arrays to store results.
        % outcome under optimal policy under discretion
        a = zeros(T+1,n_eps,n_u) ; % this is a(t) in the note, i.e. E_t(x(t+1)|e,u)
        b = zeros(T+1,n_eps,n_u) ; % this is b(t) in the notes
        XX = zeros(T,n_eps,n_u) ; % dummy : 1 if ZLB binds, 0 if not
        x_path = zeros(T,n_eps,n_u) ; % output gap
        pi_path = zeros(T,n_eps,n_u) ; % inflation
        i_path = zeros(T,n_eps,n_u) ; % nominal rate
        Loss = zeros(T+1,n_eps,n_u) ; % loss function
        
        % outcome under simple rule A: set rate equal to natural rate (+ resp
        % to cost push shock)
        aR = zeros(T+1,n_eps,n_u) ;
        bR = zeros(T+1,n_eps,n_u) ;
        x_pathR = zeros(T,n_eps,n_u) ;
        pi_pathR = zeros(T,n_eps,n_u) ;
        i_pathR = zeros(T,n_eps,n_u) ;
        LossR = zeros(T+1,n_eps,n_u) ;
        
        % alternative - Fed forecasts future paths of nat rate and cost-push
        % shocks, but assumes there is no uncertainty
        aRD = zeros(T+1,n_eps,n_u) ;
        bRD = zeros(T+1,n_eps,n_u) ;
        x_pathRD = zeros(T,n_eps,n_u) ;
        pi_pathRD = zeros(T,n_eps,n_u) ;
        i_pathRD = zeros(T,n_eps,n_u) ;
        LossRD = zeros(T+1,n_eps,n_u) ;
        
        % outcome under simple rule B -- Taylor with t-v natural rate
        aRB = zeros(T+1,n_eps,n_u) ; %
        bRB = zeros(T+1,n_eps,n_u) ;
        x_pathRB = zeros(T,n_eps,n_u) ;
        pi_pathRB = zeros(T,n_eps,n_u) ;
        i_pathRB = zeros(T,n_eps,n_u) ;
        LossRB = zeros(T+1,n_eps,n_u) ;
        
        % outcome under simple rule RC  -- Taylor with constant natural rate
        aRC = zeros(T+1,n_eps,n_u) ;
        bRC = zeros(T+1,n_eps,n_u) ;
        x_pathRC = zeros(T,n_eps,n_u) ;
        pi_pathRC = zeros(T,n_eps,n_u) ;
        i_pathRC = zeros(T,n_eps,n_u) ;
        LossRC = zeros(T+1,n_eps,n_u) ;
        aRC(T+1,:,:) = (1-beta)/kappa*(rho_hat-rho_end)  ; % if rho_hat~=rho_end i.e. Taylor does not have the right intercept, then there's a permanent gap.
        bRC(T+1,:,:) = (rho_hat-rho_end)  ;
        
        Loss(T+1,1:n_eps,1:n_u) = 0 ;
        LossR(T+1,1:n_eps,1:n_u) = 0 ;
        LossRB(T+1,1:n_eps,1:n_u) = 0 ;
        LossRC(T+1,1:n_eps,1:n_u) = .5*(rho_hat-rho_end)^2/(1-beta)*(1+lambda*((1-beta)/kappa)^2) ; % ... and consequently there's a loss
        LossRD(T+1,1:n_eps,1:n_u) = 0 ;
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % solve by backward induction %
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        t = T ;
        
        while t>=1
            
            current_b = squeeze(b(t,:,:)) ;
            current_a = squeeze(a(t,:,:)) ;
            
            current_bR = squeeze(bR(t,:,:)) ;
            current_aR = squeeze(aR(t,:,:)) ;
            
            current_bRD = squeeze(bR(t,:,:)) ;
            current_aRD = squeeze(aR(t,:,:)) ;
            
            current_bRB = squeeze(bRB(t,:,:)) ;
            current_aRB = squeeze(aRB(t,:,:)) ;
            
            current_bRC = squeeze(bRC(t,:,:)) ;
            current_aRC = squeeze(aRC(t,:,:)) ;
            
            current_u = std_u*ones(n_eps,1)*grid_u ;
            current_e = std_eps*grid_eps'*ones(1,n_u) ;
            
            if t>=T3&&truncatet==1
                current_u = scaleXX*current_u ;
                current_e = scaleXX*current_e ;
            end
            
            val_rho_t = rhomean(t) + current_e ;
            
            % opt policy under discretion
            % first, find if ZLB binds --
            XXX  = ( val_rho_t + current_b + sigma*current_a + sigma*kappa/(lambda+kappa^2)*(current_u+ beta*current_b)  < ZLBI ) ;
            XX(t,:,:) = XXX ;
            % then, use formula for the different cases
            x_path(t,:,:)  =  (XXX==1).*(-(ZLBI-val_rho_t)/sigma+current_a+current_b/sigma) - kappa/(lambda+kappa^2)*(XXX==0).*( beta*current_b + current_u ) ;
            pi_path(t,:,:) =  (XXX==1).*(kappa*(-(ZLBI-val_rho_t)/sigma+current_a+current_b/sigma) + beta*current_b + current_u ) + lambda/(lambda+kappa^2)*(XXX==0).*( beta*current_b + current_u ) ;
            i_path(t,:,:)  =  (XXX==1).*ZLBI + (XXX==0).*(val_rho_t+current_b+sigma*current_a + sigma*kappa/(lambda+kappa^2)*(current_u+ beta*current_b)) ;
            
            % calculate outcomes under simple rule A - set natural rate
            % today (plus resp to cost_push shock)
            
            i_pathR(t,:,:) = max( ZLBI, val_rho_t + sigma*kappa/(lambda+kappa^2)*(current_u)) ;
            x_pathR(t,:,:) =  current_aR - 1/sigma*(squeeze(i_pathR(t,:,:))-val_rho_t-current_bR) ;
            pi_pathR(t,:,:) = beta*current_bR + kappa*squeeze(x_pathR(t,:,:)) + current_u ;
            
            % rule D:: the Fed believes there is no uncertainty. it also believes the private sector believes there is no uncertainty.
            % the nat rate is assumed to mean revert. (cost-push shock is IID)
            
            for i=1:n_eps ;
                
                rhopath_assumed = zeros(T,1) ;
                xpath_assumed = zeros(T,1) ;
                pipath_assumed = zeros(T,1) ;
                rhopath_assumed(t:T) = rhomean(t:T) +  grid_eps(i)*std_eps*ac_eps.^(0:1:T-t)';
                if t>=T3&&truncatet==1
                    rhopath_assumed(t:T) = rhomean(t:T) +  grid_eps(i)*scaleXX*std_eps*ac_eps.^(0:1:T-t)';
                end
                
                tt = T ;
                while tt>=t+1;
                    if tt<T
                        pp = pipath_assumed(tt+1) ;
                        xx = xpath_assumed(tt+1) ;
                    else
                        pp = 0 ;
                        xx = 0 ;
                    end
                    if -beta*kappa/(lambda+kappa^2)*pp<=xx-1/sigma*(ZLBI-rhopath_assumed(tt)-pp) ; % ZLB not binding --
                        xpath_assumed(tt) = -kappa/(lambda+kappa^2)*beta*pp ;
                        pipath_assumed(tt) = lambda/(lambda+kappa^2)*beta*pp ;
                    else
                        xpath_assumed(tt) = xx - 1/sigma*(ZLBI-rhopath_assumed(tt)-pp) ;
                        pipath_assumed(tt) = beta*pp + kappa*xpath_assumed(tt) ;
                    end
                    tt = tt - 1 ;
                end
                
                for j=1:n_u;
                    if t<T
                        i_pathRD(t,i,j) = max(ZLBI,val_rho_t(i,j) + sigma*kappa/(lambda+kappa^2)*(current_u(i,j)+beta*pipath_assumed(t+1)) + sigma*xpath_assumed(t+1)+pipath_assumed(t+1) ) ;
                    else
                        i_pathRD(t,i,j) = max(ZLBI,val_rho_t(i,j) + sigma*kappa/(lambda+kappa^2)*(current_u(i,j))) ;
                    end
                end
            end
            
            x_pathRD(t,:,:) =  current_aRD - 1/sigma*(squeeze(i_pathRD(t,:,:))-val_rho_t-current_bRD) ;
            pi_pathRD(t,:,:) = beta*current_bRD + kappa*squeeze(x_pathRD(t,:,:)) + current_u ;
            
            % rule B - taylor rule with time-varying natural rate
            % first try solution outside ZLB
            x_pathRB(t,:,:) =  1/(1+(gammaB+kappa*phiB)/sigma)*(current_aRB - phiB/sigma*(beta*current_bRB+current_u)-1/sigma*(val_rho_t-val_rho_t-current_bRB)) ;
            pi_pathRB(t,:,:) = beta*current_bRB + kappa*squeeze(x_pathRB(t,:,:)) + current_u ;
            i_pathRB(t,:,:) = val_rho_t + phiB*squeeze(pi_pathRB(t,:,:)) + gammaB*squeeze(x_pathRB(t,:,:)) ;
            
            xtt = -(ZLBI-val_rho_t)/sigma+current_aRB +current_bRB/sigma ;
            pitt = beta*current_bRB + kappa*xtt + current_u ;
            J1 = (squeeze(i_pathRB(t,:,:))>=ZLBI) ;
            check_consistency1 = val_rho_t(J1)+phiB*pitt(J1)+gammaB*xtt(J1)-ZLBI ;
            if min(check_consistency1(:))<0
                disp('consistency issue w TR equilibrum: two solutions')
                disp('Rule B')
            end
            J2 = (squeeze(i_pathRB(t,:,:))<ZLBI) ;
            interm_1 = i_pathRB(t,:,:) ;
            interm_2 = x_pathRB(t,:,:) ;
            interm_3 = pi_pathRB(t,:,:) ;
            interm_1(J2) = ZLBI ;
            interm_2(J2) = xtt(J2) ;
            interm_3(J2) = pitt(J2) ;
            i_pathRB(t,:,:) = interm_1 ;
            x_pathRB(t,:,:) = interm_2 ;
            pi_pathRB(t,:,:) = interm_3 ;
            check_consistency2 = val_rho_t(J2) + phiB*pitt(J2) + gammaB*xtt(J2) - ZLBI ;
            if max(check_consistency2)>0
                disp('consistency issue w TR equilibrum: zero solution')
                disp('Rule B')
            end
            
            % taylor rule with constant natural rate
            x_pathRC(t,:,:) =  1/(1+(gammaC+kappa*phiC)/sigma)*(current_aRC - phiC/sigma*(beta*current_bRC+current_u)-1/sigma*(rho_hat-val_rho_t-current_bRC)) ;
            pi_pathRC(t,:,:) = beta*current_bRC + kappa*squeeze(x_pathRC(t,:,:)) + current_u ;
            i_pathRC(t,:,:) = rho_hat + phiC*squeeze(pi_pathRC(t,:,:)) +gammaC*squeeze(x_pathRC(t,:,:)) ;
            
            xtt = -(ZLBI-val_rho_t)/sigma+current_aRC +current_bRC/sigma ;
            pitt = beta*current_bRC + kappa*xtt + current_u ;
            J1 = (squeeze(i_pathRC(t,:,:))>=ZLBI) ;
            check_consistency1 = rho_hat +phiC*pitt(J1)+gammaC*xtt(J1)-ZLBI ;
            if min(check_consistency1(:))<0
                disp('consistency issue w TR equilibrum: two solutions')
                disp('Rule C')
            end
            J2 = (squeeze(i_pathRC(t,:,:))<ZLBI) ;
            interm_1 = i_pathRC(t,:,:) ;
            interm_2 = x_pathRC(t,:,:) ;
            interm_3 = pi_pathRC(t,:,:) ;
            interm_1(J2) = ZLBI ;
            interm_2(J2) = xtt(J2) ;
            interm_3(J2) = pitt(J2) ;
            i_pathRC(t,:,:) = interm_1 ;
            x_pathRC(t,:,:) = interm_2 ;
            pi_pathRC(t,:,:) = interm_3 ;
            check_consistency2 = rho_hat + phiC*pitt(J2) + gammaC*xtt(J2) - ZLBI ;
            if max(check_consistency2)>0
                disp('consistency issue w TR equilibrum: zero solution')
                disp('Rule C')
            end
            
            
            if t>=2
                AA1 = squeeze(x_path(t,:,:))  ;
                AA2 = squeeze(x_pathR(t,:,:))  ;
                AA3 = squeeze(x_pathRB(t,:,:))  ;
                AA4 = squeeze(x_pathRC(t,:,:))  ;
                AA5 = squeeze(x_pathRD(t,:,:))  ;
                
                BB1 = squeeze(pi_path(t,:,:)) ;
                BB2 = squeeze(pi_pathR(t,:,:)) ;
                BB3 = squeeze(pi_pathRB(t,:,:)) ;
                BB4 = squeeze(pi_pathRC(t,:,:)) ;
                BB5 = squeeze(pi_pathRD(t,:,:)) ;
                
                for j=1:n_eps
                    for k=1:n_u
                        a(t-1,j,k) = P_eps(j,:)*AA1*P_u(k,:)' ;
                        b(t-1,j,k) = P_eps(j,:)*BB1*P_u(k,:)' ;
                        
                        aR(t-1,j,k) = P_eps(j,:)*AA2*P_u(k,:)' ;
                        bR(t-1,j,k) = P_eps(j,:)*BB2*P_u(k,:)' ;
                        
                        aRB(t-1,j,k) = P_eps(j,:)*AA3*P_u(k,:)' ;
                        bRB(t-1,j,k) = P_eps(j,:)*BB3*P_u(k,:)' ;
                        
                        aRC(t-1,j,k) = P_eps(j,:)*AA4*P_u(k,:)' ;
                        bRC(t-1,j,k) = P_eps(j,:)*BB4*P_u(k,:)' ;
                        
                        aRD(t-1,j,k) = P_eps(j,:)*AA5*P_u(k,:)' ;
                        bRD(t-1,j,k) = P_eps(j,:)*BB5*P_u(k,:)' ;
                    end
                end
            end
            
            % calculate loss --
            CC1 = squeeze(Loss(t+1,:,:)) ;
            CC2 = squeeze(LossR(t+1,:,:)) ;
            CC3 = squeeze(LossRB(t+1,:,:)) ;
            CC4 = squeeze(LossRC(t+1,:,:)) ;
            CC5 = squeeze(LossRD(t+1,:,:)) ;
            
            for j=1:n_eps
                for k=1:n_u
                    Loss(t,j,k)   = .5*(x_path(t,j,k)^2*lambda  + pi_path(t,j,k)^2  )  + beta*P_eps(j,:)*CC1*P_u(k,:)' ;
                    LossR(t,j,k)  = .5*(x_pathR(t,j,k)^2*lambda + pi_pathR(t,j,k)^2  ) + beta*P_eps(j,:)*CC2*P_u(k,:)' ;
                    LossRB(t,j,k) = .5*(x_pathRB(t,j,k)^2*lambda + pi_pathRB(t,j,k)^2)  + beta*P_eps(j,:)*CC3*P_u(k,:)' ;
                    LossRC(t,j,k) = .5*(x_pathRC(t,j,k)^2*lambda + pi_pathRC(t,j,k)^2) + beta*P_eps(j,:)*CC4*P_u(k,:)' ;
                    LossRD(t,j,k) = .5*(x_pathRD(t,j,k)^2*lambda + pi_pathRD(t,j,k)^2) + beta*P_eps(j,:)*CC5*P_u(k,:)' ;
                end
            end
            
            t = t - 1 ;
            
        end
        
        % save results
        if is==1
            x_path1 = x_path ;
            pi_path1 = pi_path ;
            i_path1 = i_path ;
            Loss1 = Loss ;
            
            x_pathR1 = x_pathR ;
            pi_pathR1 = pi_pathR ;
            i_pathR1 = i_pathR ;
            LossR1 = LossR ;
            
            x_pathRB1 = x_pathRB ;
            pi_pathRB1 = pi_pathRB ;
            i_pathRB1 = i_pathRB ;
            LossRB1 = LossRB ;
            
            x_pathRC1 = x_pathRC ;
            pi_pathRC1 = pi_pathRC ;
            i_pathRC1 = i_pathRC ;
            LossRC1 = LossRC ;
            
            x_pathRD1 = x_pathRD ;
            pi_pathRD1 = pi_pathRD ;
            i_pathRD1 = i_pathRD ;
            LossRD1 = LossRD ;
            
            meani1 = i_path1(:,medeps,medu) ;
            meanx1 = x_path1(:,medeps,medu) ;
            meanpi1 = pi_path1(:,medeps,medu) ;
            
            meaniR1 = i_pathR1(:,medeps,medu) ;
            meanxR1 = x_pathR1(:,medeps,medu) ;
            meanpiR1 = pi_pathR1(:,medeps,medu) ;
            
            meaniRB1 = i_pathRB1(:,medeps,medu) ;
            meanxRB1 = x_pathRB1(:,medeps,medu) ;
            meanpiRB1 = pi_pathRB1(:,medeps,medu) ;
            
            meaniRC1 = i_pathRC1(:,medeps,medu) ;
            meanxRC1 = x_pathRC1(:,medeps,medu) ;
            meanpiRC1 = pi_pathRC1(:,medeps,medu) ;
            
            meaniRD1 = i_pathRD1(:,medeps,medu) ;
            meanxRD1 = x_pathRD1(:,medeps,medu) ;
            meanpiRD1 = pi_pathRD1(:,medeps,medu) ;
        end
        
        if is==2
            x_path2 = x_path ;
            pi_path2 = pi_path ;
            i_path2 = i_path ;
            Loss2 = Loss ;
            
            x_pathR2 = x_pathR ;
            pi_pathR2 = pi_pathR ;
            i_pathR2 = i_pathR ;
            LossR2 = LossR ;
            
            x_pathRB2 = x_pathRB ;
            pi_pathRB2 = pi_pathRB ;
            i_pathRB2 = i_pathRB ;
            LossRB2 = LossRB ;
            
            x_pathRC2 = x_pathRC ;
            pi_pathRC2 = pi_pathRC ;
            i_pathRC2 = i_pathRC ;
            LossRC2 = LossRC ;
            
            x_pathRD2 = x_pathRD ;
            pi_pathRD2 = pi_pathRD ;
            i_pathRD2 = i_pathRD ;
            LossRD2 = LossRD ;
            
            meanx2 = x_path2(:,medeps,medu) ;
            meani2 = i_path2(:,medeps,medu) ;
            meanpi2 = pi_path2(:,medeps,medu) ;
            
            meaniR2 = i_pathR2(:,medeps,medu) ;
            meanxR2 = x_pathR2(:,medeps,medu) ;
            meanpiR2 = pi_pathR2(:,medeps,medu) ;
            
            meaniRB2 = i_pathRB2(:,medeps,medu) ;
            meanxRB2 = x_pathRB2(:,medeps,medu) ;
            meanpiRB2 = pi_pathRB2(:,medeps,medu) ;
            
            meaniRC2 = i_pathRC2(:,medeps,medu) ;
            meanxRC2 = x_pathRC2(:,medeps,medu) ;
            meanpiRC2 = pi_pathRC2(:,medeps,medu) ;
            
            meaniRD2 = i_pathRD2(:,medeps,medu) ;
            meanxRD2 = x_pathRD2(:,medeps,medu) ;
            meanpiRD2 = pi_pathRD2(:,medeps,medu) ;
        end
        if is==3
            x_path3 = x_path ;
            pi_path3 = pi_path ;
            i_path3 = i_path ;
            Loss3 = Loss ;
            
            x_pathR3 = x_pathR ;
            pi_pathR3 = pi_pathR ;
            i_pathR3 = i_pathR ;
            LossR3 = LossR ;
            
            x_pathRB3 = x_pathRB ;
            pi_pathRB3 = pi_pathRB ;
            i_pathRB3 = i_pathRB ;
            LossRB3 = LossRB ;
            
            x_pathRC3 = x_pathRC ;
            pi_pathRC3 = pi_pathRC ;
            i_pathRC3 = i_pathRC ;
            LossRC3 = LossRC ;
            
            x_pathRD3 = x_pathRD ;
            pi_pathRD3 = pi_pathRD ;
            i_pathRD3 = i_pathRD ;
            LossRD3 = LossRD ;
            
            meanx3 = x_path3(:,medeps,medu) ;
            meani3 = i_path3(:,medeps,medu) ;
            meanpi3 = pi_path3(:,medeps,medu) ;
            
            meaniR3 = i_pathR3(:,medeps,medu) ;
            meanxR3 = x_pathR3(:,medeps,medu) ;
            meanpiR3 = pi_pathR3(:,medeps,medu) ;
            
            meaniRB3 = i_pathRB3(:,medeps,medu) ;
            meanxRB3 = x_pathRB3(:,medeps,medu) ;
            meanpiRB3 = pi_pathRB3(:,medeps,medu) ;
            
            meaniRC3 = i_pathRC3(:,medeps,medu) ;
            meanxRC3 = x_pathRC3(:,medeps,medu) ;
            meanpiRC3 = pi_pathRC3(:,medeps,medu) ;
            
            meaniRD3 = i_pathRD3(:,medeps,medu) ;
            meanxRD3 = x_pathRD3(:,medeps,medu) ;
            meanpiRD3 = pi_pathRD3(:,medeps,medu) ;
            
        end
        
    end
    
%     figure_FL ;
    
    simuls_FL ;
    
%     illustrate_shocksFL ;
    
%     figure_FLmeanmedian ;
    
    eval(strcat('save finalresFLXs_',num2str(usus))) ;
    
end

